#ifndef _TPM2
#define _TPM2


#include <hidef.h> /* for EnableInterrupts macro */
#include "derivative.h" /* include peripheral declarations */
#include "PublicTypes.h"
#include "SystemConfig.h"


/**********************************+
	TPM2 configuration
*********************************/
#define DESIRED_FREQ				100000		//1/20kHz = 50 us
#define TPM2_OVF_PERIOD_us			10

#define TPM2_PRESCALER   (1)
#define TPM2_PRESCALER_VALUE	(0b000)
/* Check this table to select proper value, it must match the TPM2_PRESCALER value
	0:0:0 	1
	0:0:1 	2
	0:1:0 	4
	0:1:1 	8
	1:0:0 	16
	1:0:1 	32
	1:1:0 	64
	1:1:1 	128
*/


#define TPM2_FREQ        ((UINT32)(BUS_FREQ/TPM2_PRESCALER)) 


#define TPM2_PS_VALUE	((UINT8)(TPM2_PRESCALER_VALUE)|TPM2SC_TOIE_MASK)
#define TPM2_MOD_VALUE	((UINT16)(TPM2_FREQ/DESIRED_FREQ))
														/*
    						
    						 			   BUS_FREQ	
    						TPM_FREQ = ---------------
    									TMP_PRESCALER
    						
    						
    								  	TMP_FREQ
    						MODULO = --------------------
    								 DESIRED_FREQ (Hz)
    													*/

/** Starts the TPM */
#define TPM2_START()      	TPM2SC_CLKSx = 0x1

/** Stops the TPM */
#define TPM2_STOP()       	TPM2SC_CLKSx = 0x0

/** Clears the TPM flag */
#define TMP2_CLEAR_OV_FLAG()		TPM2SC_TOF = 0x00

extern UINT16 ElapsedTimeIn_us;

void Tpm2_Init(void);



#endif //_TPM2